%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
% Program to identify the new signal 
%    with respect to reference set
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

clear all;
close all;

% Time measurement
tic
% goto the reqd dir
current_dir = pwd;
cd c:/cardiacsignals/;

% first write the filenames with .xls extension to a text file. 
system('dir /b *.xls > temp_list.txt')

% open the file
file_id = fopen('temp_list.txt', 'r');

string_line= fgets(file_id);

data = 0;
i = 1;

while (string_line ~= -1)
        string_line= fgets(file_id);
        
        if (string_line ~= -1)
            fprintf('\nreading from file %s\n', string_line);
               temp= read_xls_file(string_line(1:length(string_line)-1));

               % Keeping the track of file names...
               %file_name (i,:) = string_line;
               
               % keeping the track of the size
               
               len (i) = length ( temp);
               
               % verify whether the new signal has more data than previous
               % ones
               
               if ( length(data) < length (temp) )
                  for j = length (data) : length (temp)
                      data (j, :) = 0;
                  end
               else
                   % if new signal size is less than data lenght then pad
                   % zeros at the end of new signal
                   
                   if ( length (data) > length ( temp) )
                       
                       for j = length (temp) : length (data)
                           temp (j, 1) = 0;
                       end
                       
                   end
               end
               
               data (:, i) = temp;
               i = i + 1;
        end
end

% Correlation 
data_size = size ( data);

for i =1 : data_size (2)
    for j = 1: data_size (2)
        
%         disp (i)
%         disp (j)
        sig1 = data (1:len (i), i);
        sig1 = sig1 / norm (sig1);
        
        sig2 = data (1:len (j), j);
        sig2 = sig2 / norm (sig2);
        
        temp = xcorr ( sig1, sig2 );

        corr_mat (i, j) = temp ( (length (temp ) +1)/ 2);
    end
end

for i = 1: data_size (2) 
    for j = 1:data_size (2) 
        per_corr (i, j) = corr_mat (i, j) / corr_mat (i, i);
    end
end

% Finding Correlation for new cardiac signal

cd F:\unknownsignals;
new_signal = xlsread ('unkwn2.xls');
new_signal = new_signal (:, 2);

%  Assumption : length of new signal is less than the length of data

for i =1:data_size (2)
    sig = data (1: length (new_signal), i);
    sig = sig / norm (sig);
    
    present_corr = xcorr (sig, new_signal);
    corr_coef (i) =present_corr ( ceil ( (length (sig)+ length (new_signal)+1) / 2) ) ;
end

%disp (' Correlation vector is  ')
%disp (corr_coef)

% Finding the max correlation coeff 

[max_corr , pos] = max (corr_coef);
% 
% for i = 1:data_size (2)
%     if (max_corr == corr_coef (i) )
%         pos = i;
%     end
% end

fclose (file_id);
cd  c:/cardiacsignals/;

file_id = fopen('temp_list.txt', 'r');

string_line= fgets (file_id);
i = 1;

while (string_line ~= -1)
        string_line= fgets (file_id);
        
        if (string_line ~= -1 & i <pos)
            i = i+1;
        else
            break;
        end
        string_line = fgets (file_id);%gets the name of file from ref set 
        %with highest similariity with unknown signal
end

disp ('Max correlation with Signal ')
%disp (file_name (pos)
disp (string_line)
% disp (pos)

% Ploting 

% Equalling data size

sig = data (1:length (new_signal), pos);
sig = sig / norm (sig);
norm_new_signal = new_signal / norm (new_signal);

%figure
%mesh(corr_mat);
%title('Correlation Matrix');

%figure
%plot (sig, 'b');%anup sig
%hold on;
%plot (new_signal, 'r');%anup
%grid
%legend('Best matching Reference signal', 'Test Signal', 'location', 'Best');
%title('Plot of the Best Reference Signal and the test set');
%xlabel('sample number');
%ylabel('ECG Amplitude')

% close the file.
fclose(file_id);

% get back to the old dir
cd(current_dir)

toc
% End of time calculation
